#include "BOOTPHeader.h"
#include "utils.h"
#include <pcap.h>

BOOTPHeader::BOOTPHeader(u_char _op, u_long _xid, u_char* _srcMAC) {
  memset(&data, 0, BOOTP_HEADER_SIZE);
  data.op = _op;
  data.htype = BOOTP_HTYPE_ETHERNET;
  data.hlen = ETH_ALEN;
  data.hops = 0;
  data.xid = _xid;
  data.secs = 0;
  memcpy(data.chaddr, _srcMAC, ETH_ALEN);
}

BOOTPHeader::BOOTPHeader(const u_char* _data) {
  memcpy(&data, _data, BOOTP_HEADER_SIZE);
  // prevod z net formatu
  data2host();
}

void BOOTPHeader::setMem(u_char* _data) {
  data2network();
  memcpy(_data, &data, BOOTP_HEADER_SIZE);
  data2host();
}

void BOOTPHeader::dump( void ) {
  cout << "BOOTP Header:" << endl;
  cout << "  Opcode: " << (int) data.op << endl;
  cout << "  HW Type: " << (int) data.htype << endl;
  cout << "  HW addr len: " << (int) data.hlen << endl;
  cout << "  Hops: " << (int) data.hops << endl;
  cout << "  XID: " << data.xid << endl;
  cout << "  Secs: " << data.secs << endl;
  cout << "  Client IP: ";
  printIPAddress(data.ciaddr);
  cout << endl << "  'Your' IP: ";
  printIPAddress(data.yiaddr);
  cout << endl << "  Server IP: ";
  printIPAddress(data.siaddr);
  cout << endl << "  Gateway IP: ";
  printIPAddress(data.giaddr);
  cout << endl << "  Client MAC: ";
  printMACAddress(data.chaddr);
  cout << endl << "  Sname: " << data.sname << endl;
  cout << "  File: " << data.file << endl << endl << endl;            
}

const u_char BOOTPHeader::Opcode() const { 
  return data.op; 
}

const u_long BOOTPHeader::XID() const { 
  return data.xid; 
}

const u_char *BOOTPHeader::YourIP() const { 
  return data.yiaddr; 
}

const u_char *BOOTPHeader::ServerIP() const { 
  return data.siaddr; 
}

const u_char *BOOTPHeader::GatewayIP() const { 
  return data.giaddr; 
}

void BOOTPHeader::data2host(void) {
  data.xid = ntohl(data.xid);
  data.secs = ntohs(data.secs);
}

void BOOTPHeader::data2network(void){
  data.xid = htonl(data.xid);
  data.secs = htons(data.secs);
}
